/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TcpSocketDataTransfer;
import DE.siemens.ad.logo.dialog.PortSelectionPanel;
import DE.siemens.ad.logo.dialog.comp.IPEditPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.LogoXMLProperties;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Version;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class CommunicationSettingPanel
extends DataInputPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private PortSelectionPanel fPortSelectionPanel;
    private TCPSettingPanel fTCPSettingPanel;
    private JPanel fCommSettingPanel;
    protected JRadioButton fPCCable;
    protected JRadioButton fSocket;

    public CommunicationSettingPanel() {
        this.initComponents();
    }

    private JPanel getTypeSelectionPanel() {
        JPanel commTypePanel = new JPanel();
        commTypePanel.setLayout(new BoxLayout(commTypePanel, 0));
        this.fPCCable = new JRadioButton(Language.getString("dialog.options.connectionTab.cabel", "LOGO! Cable"));
        commTypePanel.add(this.fPCCable);
        this.fSocket = new JRadioButton(Language.getString("dialog.options.connectionTab.network", "Ethernet"));
        commTypePanel.add(this.fSocket);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.fPCCable);
        bg.add(this.fSocket);
        this.fPCCable.addActionListener(this);
        this.fSocket.addActionListener(this);
        return commTypePanel;
    }

    private PortSelectionPanel getPortSelectionPanel() {
        if (this.fPortSelectionPanel == null) {
            this.fPortSelectionPanel = new PortSelectionPanel();
        }
        return this.fPortSelectionPanel;
    }

    private TCPSettingPanel getTCPSettingPanel() {
        if (this.fTCPSettingPanel == null) {
            this.fTCPSettingPanel = new TCPSettingPanel();
        }
        return this.fTCPSettingPanel;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.fill = 2;
        this.add((Component)this.getTypeSelectionPanel(), gbc);
        this.fCommSettingPanel = new JPanel(new CardLayout());
        this.fCommSettingPanel.add((Component)this.getPortSelectionPanel(), "0");
        this.fCommSettingPanel.add((Component)this.getTCPSettingPanel(), "1");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.fill = 1;
        this.add((Component)this.fCommSettingPanel, gbc);
    }

    public boolean checkChanged() {
        return this.getPortSelectionPanel().checkChanged() || this.getTCPSettingPanel().checkChanged();
    }

    public boolean checkFieldContents() {
        return this.getPortSelectionPanel().checkFieldContents() && this.getTCPSettingPanel().checkFieldContents();
    }

    public void loadFieldContents() throws ProgramException {
        if (LogoProperties.instance().getProperty("PortTypeSelection", "SerialPortType").equals("SerialPortType")) {
            this.fPCCable.setSelected(true);
        } else {
            this.fSocket.setSelected(true);
        }
        this.updateActiveSettingPanel();
        this.getPortSelectionPanel().loadFieldContents();
        this.getTCPSettingPanel().loadFieldContents();
    }

    public void storeFieldContents() {
        if (this.fPCCable.isSelected()) {
            LogoProperties.instance().setProperty("PortTypeSelection", "SerialPortType");
        } else {
            LogoProperties.instance().setProperty("PortTypeSelection", "Socket");
        }
        this.getPortSelectionPanel().storeFieldContents();
        this.getTCPSettingPanel().storeFieldContents();
    }

    public void setLabels() {
        this.getPortSelectionPanel().setLabels();
        this.getTCPSettingPanel().setLabels();
    }

    public void actionPerformed(ActionEvent e) {
        this.updateActiveSettingPanel();
    }

    private void updateActiveSettingPanel() {
        if (this.fPCCable.isSelected()) {
            ((CardLayout)this.fCommSettingPanel.getLayout()).first(this.fCommSettingPanel);
        } else {
            ((CardLayout)this.fCommSettingPanel.getLayout()).last(this.fCommSettingPanel);
        }
    }

    public String getTitle() {
        return Language.getString("dialog.options.connectionTab.label", "Port");
    }

    public static String getIPAddressFileName() {
        Version v = Version.getCurrentVersion();
        return System.getProperty("user.home", "") + "/." + v.getApplicationFileName() + v.getMajorVersion() + "." + v.getMinorVersion() + "/" + "IPAddress.dat";
    }

    public String getHelpIdString() {
        StringBuffer buffer = new StringBuffer("dialog.CommunicationSetting");
        if (this.fPCCable.isSelected()) {
            buffer.append(".PortSelection");
        } else {
            buffer.append(".TCPSetting");
        }
        return buffer.toString();
    }

    public static class IPConfig
    implements Serializable {
        private static final long serialVersionUID = 6673568136367137670L;
        public static final int INDEX_NAME = 0;
        public static final int INDEX_IP = 1;
        public static final int INDEX_MASK = 2;
        public static final int INDEX_GATE = 3;
        public String[] values = new String[4];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IPConfigModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8778148580994895004L;
        private Vector<IPConfig> fConfigs;
        private Map<IPConfig, String> fStatus = new HashMap<IPConfig, String>();

        private IPConfigModel() {
        }

        public static IPConfigModel getIPConfigModel(int[] selection) {
            IPConfigModel model = new IPConfigModel();
            model.fConfigs = LogoXMLProperties.getInstance().getIPAddress(selection);
            return model;
        }

        public static void saveIPConfigModel(IPConfigModel model, int selectionIndex) {
            LogoXMLProperties.getInstance().storeIPAddress(model.fConfigs, selectionIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Language.getString("ethernet.tcpSettingPanel.columnName", "Name");
            }
            if (columnIndex == 1) {
                return Language.getString("ethernet.tcpSettingPanel.columnIPAddress", "IP Address");
            }
            if (columnIndex == 2) {
                return Language.getString("ethernet.tcpSettingPanel.columnSubnetmask", "Subnet Mask");
            }
            if (columnIndex == 3) {
                return Language.getString("ethernet.tcpSettingPanel.columnGateway", "Gateway");
            }
            if (columnIndex == 4) {
                return Language.getString("ethernet.tcpSettingPanel.columnStatus", "Status");
            }
            return "Error";
        }

        @Override
        public int getRowCount() {
            return this.fConfigs.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 4) {
                return this.fStatus.get(this.fConfigs.get(rowIndex));
            }
            return this.fConfigs.get((int)rowIndex).values[columnIndex];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                return;
            }
            if (col == 0) {
                this.fConfigs.get((int)row).values[col] = value.toString();
            }
        }

        public IPConfig getIPConfig(int rowIndex) {
            return this.fConfigs.get(rowIndex);
        }

        public void setConfig(IPConfig config, int rowIndex) {
            this.fConfigs.set(rowIndex, config);
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, -1, 0));
        }

        public void setStatus(String status, int rowIndex) {
            this.fStatus.put(this.fConfigs.get(rowIndex), status);
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, -1, 0));
        }

        public void InsertRow(int rowIndex, IPConfig config) {
            this.fConfigs.insertElementAt(config, rowIndex);
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, -1, 1));
        }

        public void deleteRow(int rowIndex) {
            this.fStatus.remove(this.fConfigs.remove(rowIndex));
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, -1, -1));
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }

    public static class TCPSettingPanel
    extends DataInputPanel {
        private static final long serialVersionUID = 1L;
        private JTable fTable;
        private IPConfigModel fModel;
        private JButton fAddButton;
        private JCheckBox fChkConfirmSelection;
        private IPConfig fIPConfig;

        public TCPSettingPanel() {
            this.initComponents();
        }

        private JTable getTable() {
            if (this.fTable == null) {
                this.fTable = new JTable();
                this.fTable.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && TCPSettingPanel.this.fTable.getSelectedColumn() >= 1 && TCPSettingPanel.this.fTable.getSelectedColumn() <= 3) {
                            TCPSettingPanel.this.editSelectedConfig();
                        }
                    }
                });
                this.fTable.setColumnSelectionAllowed(false);
                this.fTable.setSelectionMode(0);
            }
            return this.fTable;
        }

        private void initComponents() {
            JPanel pane = new JPanel(new GridBagLayout());
            JScrollPane scrollPane = new JScrollPane(pane);
            this.setLayout(new BorderLayout());
            this.add(scrollPane);
            JScrollPane tablePanel = new JScrollPane(this.getTable());
            tablePanel.setPreferredSize(new Dimension(300, 120));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 5, 0, 0);
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.fill = 1;
            pane.add((Component)tablePanel, gbc);
            JPanel buttonPanel = new JPanel();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(5, 5, 0, 0);
            pane.add((Component)buttonPanel, gbc);
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            JButton fDetectButton = new JButton(Language.getString("dialog.options.connectionTab.detectButton", "Detect"));
            buttonPanel.add(fDetectButton);
            fDetectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TCPSettingPanel.this.detectAllAddress();
                }
            });
            this.fAddButton = new JButton(Language.getString("dialog.options.connectionTab.addButton", "Add"));
            buttonPanel.add(this.fAddButton);
            this.fAddButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IPConfig config = TCPSettingPanel.this.editConfig(null);
                    if (config != null) {
                        TCPSettingPanel.this.fModel.InsertRow(TCPSettingPanel.this.fModel.getRowCount(), config);
                        if (TCPSettingPanel.this.fModel.getRowCount() == 1) {
                            TCPSettingPanel.this.getTable().getSelectionModel().setSelectionInterval(0, 0);
                        }
                    }
                }
            });
            JButton deleteButton = new JButton(Language.getString("dialog.options.connectionTab.deleteButton", "Delete"));
            buttonPanel.add(deleteButton);
            deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selectedRow = TCPSettingPanel.this.getTable().getSelectedRow();
                    if (selectedRow >= 0 && selectedRow < TCPSettingPanel.this.fModel.getRowCount()) {
                        TCPSettingPanel.this.fModel.deleteRow(selectedRow);
                        if (selectedRow >= TCPSettingPanel.this.fModel.getRowCount()) {
                            selectedRow = TCPSettingPanel.this.fModel.getRowCount() - 1;
                        }
                        TCPSettingPanel.this.getTable().getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                    }
                }
            });
            JButton editButton = new JButton(Language.getString("dialog.options.connectionTab.editButton", "Edit"));
            buttonPanel.add(editButton);
            editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TCPSettingPanel.this.editSelectedConfig();
                }
            });
            this.fChkConfirmSelection = new JCheckBox(Language.getString("dialog.options.interface.confirmBeforeCommunication", "Confirm before communication?"));
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            pane.add((Component)this.fChkConfirmSelection, gbc);
        }

        public void loadFieldContents() throws ProgramException {
            int[] selection = new int[1];
            this.fModel = IPConfigModel.getIPConfigModel(selection);
            this.fTable.setModel(this.fModel);
            if (selection[0] >= 0 && selection[0] < this.fModel.getRowCount()) {
                this.getTable().getSelectionModel().setSelectionInterval(selection[0], selection[0]);
            }
            for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
                this.fTable.getColumnModel().getColumn(i).setMinWidth(60);
            }
            this.fChkConfirmSelection.setSelected(LogoProperties.instance().getBooleanProperty("ConfirmIPAddressBeforeComm", true));
        }

        public boolean checkFieldContents() {
            if (this.getTable().isEditing()) {
                return this.getTable().getCellEditor().stopCellEditing();
            }
            return true;
        }

        public void storeFieldContents() {
            int selectedRow = this.getTable().getSelectedRow();
            if (selectedRow >= 0 && selectedRow < this.fModel.getRowCount()) {
                LogoProperties.instance().setProperty("LOGOIpAddress", this.fModel.getIPConfig((int)selectedRow).values[1]);
                this.fIPConfig = new IPConfig();
                this.fIPConfig.values[1] = this.fModel.getIPConfig((int)selectedRow).values[1];
                this.fIPConfig.values[2] = this.fModel.getIPConfig((int)selectedRow).values[2];
                this.fIPConfig.values[3] = this.fModel.getIPConfig((int)selectedRow).values[3];
            } else {
                this.fIPConfig = null;
            }
            IPConfigModel.saveIPConfigModel(this.fModel, selectedRow);
            LogoProperties.instance().setBooleanProperty("ConfirmIPAddressBeforeComm", this.fChkConfirmSelection.isSelected());
        }

        public IPConfig getIPConfig() {
            return this.fIPConfig;
        }

        private void editSelectedConfig() {
            IPConfig config;
            int selectedRow = this.getTable().getSelectedRow();
            if (selectedRow >= 0 && selectedRow < this.fModel.getRowCount() && (config = this.editConfig(this.fModel.getIPConfig(selectedRow))) != null) {
                this.fModel.setConfig(config, selectedRow);
            }
        }

        private IPConfig editConfig(IPConfig preConfig) {
            IPConfig ret;
            if (preConfig == null) {
                ret = new IPConfig();
                ret.values[0] = Language.getString("ethernet.tcpSettingPanel.connection.defaultName", "New Address");
            } else {
                ret = preConfig;
            }
            IPEditPanel panel = new IPEditPanel(ret);
            SplittedDlg dlg = SplittedDlg.create(null, panel, 3);
            dlg.show();
            if (dlg.getControlPanel().getResult() != 1) {
                return null;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void detectAllAddress() {
            int selectedRow = this.getTable().getSelectedRow();
            if (selectedRow >= 0 && selectedRow < this.fModel.getRowCount()) {
                IPConfig config = this.fModel.getIPConfig(selectedRow);
                DataTransfer dt = null;
                try {
                    this.fAddButton.setEnabled(false);
                    String IPAddress = config.values[1];
                    dt = TcpSocketDataTransfer.openConnection(IPAddress, false, false);
                    dt.closePort();
                    this.fModel.setStatus(Language.getString("dialog.error.yes", "Yes"), selectedRow);
                }
                catch (Exception e) {
                    this.fModel.setStatus(Language.getString("dialog.error.no", "No"), selectedRow);
                }
                finally {
                    if (dt != null) {
                        dt.closePort();
                        dt = null;
                    }
                }
                this.fAddButton.setEnabled(true);
            }
        }
    }
}

